package com.xforceplus.jcunilever.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcunilever.entity.TimedTaskGlobalSwitch;
import com.xforceplus.jcunilever.service.ITimedTaskGlobalSwitchService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-04-11
 */
@RestController
public class TimedTaskGlobalSwitchController {

  @Autowired
  private ITimedTaskGlobalSwitchService timedTaskGlobalSwitchServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param timedTaskGlobalSwitch ${table.comment}
   * @return
   */
  @GetMapping("/timedtaskglobalswitchs" )
  public XfR getTimedTaskGlobalSwitchs(XfPage page, TimedTaskGlobalSwitch timedTaskGlobalSwitch) {
    return XfR.ok(timedTaskGlobalSwitchServiceImpl.page(page, Wrappers.query(timedTaskGlobalSwitch)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/timedtaskglobalswitchs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(timedTaskGlobalSwitchServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param timedTaskGlobalSwitch ${table.comment}
   * @return XfR
   */
  @PostMapping("/timedtaskglobalswitchs")
  public XfR save(@RequestBody TimedTaskGlobalSwitch timedTaskGlobalSwitch) {
     return XfR.ok(timedTaskGlobalSwitchServiceImpl.save(timedTaskGlobalSwitch));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param timedTaskGlobalSwitch ${table.comment}
   * @return XfR
   */
  @PutMapping("/timedtaskglobalswitchs/{id}")
  public XfR putUpdate(@RequestBody TimedTaskGlobalSwitch timedTaskGlobalSwitch,@PathVariable Long id) {
      timedTaskGlobalSwitch.setId(id);
      return XfR.ok(timedTaskGlobalSwitchServiceImpl.updateById(timedTaskGlobalSwitch));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param timedTaskGlobalSwitch ${table.comment}
   * @return XfR
   */
  @PatchMapping("/timedtaskglobalswitchs/{id}")
  public XfR patchUpdate(@RequestBody TimedTaskGlobalSwitch timedTaskGlobalSwitch,@PathVariable Long id) {
      TimedTaskGlobalSwitch uptimedTaskGlobalSwitch = timedTaskGlobalSwitchServiceImpl.getById(id);
      if(uptimedTaskGlobalSwitch != null){
        uptimedTaskGlobalSwitch = ObjectCopyUtils.copyProperties(timedTaskGlobalSwitch,uptimedTaskGlobalSwitch,true);
      }
      return XfR.ok(timedTaskGlobalSwitchServiceImpl.updateById(uptimedTaskGlobalSwitch));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/timedtaskglobalswitchs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(timedTaskGlobalSwitchServiceImpl.removeById(id));
  }

  @PostMapping("/timedtaskglobalswitchs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "timed_task_global_switch");
     params.put("request", condition);

     return XfR.ok(timedTaskGlobalSwitchServiceImpl.querys(params));
  }

}
