package com.xforceplus.jcvankepurchaser.controller;


/**
 * 报表主数据feign客户端
 *
 * @author ultraman
 * @date 2023-08-25
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcvankepurchaser.entity.PerpetualCalendar;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-vanke-purchaser")
public interface PerpetualCalendarFeignApi {

  /**
   * 通过id查询报表主数据
   * @param  id
   * @return R
   */
  @GetMapping("/perpetualCalendar/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增报表主数据
   * @param perpetualCalendar 报表主数据
   * @return R
   */
  @PostMapping("/perpetualCalendar/add")
  public R save(@RequestBody PerpetualCalendar perpetualCalendar);

  /**
   * 修改报表主数据
   * @param perpetualCalendar 报表主数据
   * @return R
   */
  @PostMapping("/perpetualCalendar/update")
  public R updateById(@RequestBody PerpetualCalendar perpetualCalendar);

  /**
   * 通过id删除报表主数据
   * @param  id
   * @return R
   */
  @DeleteMapping("/perpetualCalendar/del/{id}" )
  public R removeById(@PathVariable Long id);

}