package com.xforceplus.jcvankepurchaser.controller;


/**
 * 报表feign客户端
 *
 * @author ultraman
 * @date 2023-08-30
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcvankepurchaser.entity.OrderErrorStatement;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-vanke-purchaser")
public interface OrderErrorStatementFeignApi {

  /**
   * 通过id查询报表
   * @param  id
   * @return R
   */
  @GetMapping("/orderErrorStatement/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增报表
   * @param orderErrorStatement 报表
   * @return R
   */
  @PostMapping("/orderErrorStatement/add")
  public R save(@RequestBody OrderErrorStatement orderErrorStatement);

  /**
   * 修改报表
   * @param orderErrorStatement 报表
   * @return R
   */
  @PostMapping("/orderErrorStatement/update")
  public R updateById(@RequestBody OrderErrorStatement orderErrorStatement);

  /**
   * 通过id删除报表
   * @param  id
   * @return R
   */
  @DeleteMapping("/orderErrorStatement/del/{id}" )
  public R removeById(@PathVariable Long id);

}