package com.xforceplus.jcvankepurchaser.controller;


/**
 * 报表feign客户端
 *
 * @author ultraman
 * @date 2023-08-30
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcvankepurchaser.entity.OrdersEndcheck;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-vanke-purchaser")
public interface OrdersEndcheckFeignApi {

  /**
   * 通过id查询报表
   * @param  id
   * @return R
   */
  @GetMapping("/ordersEndcheck/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增报表
   * @param ordersEndcheck 报表
   * @return R
   */
  @PostMapping("/ordersEndcheck/add")
  public R save(@RequestBody OrdersEndcheck ordersEndcheck);

  /**
   * 修改报表
   * @param ordersEndcheck 报表
   * @return R
   */
  @PostMapping("/ordersEndcheck/update")
  public R updateById(@RequestBody OrdersEndcheck ordersEndcheck);

  /**
   * 通过id删除报表
   * @param  id
   * @return R
   */
  @DeleteMapping("/ordersEndcheck/del/{id}" )
  public R removeById(@PathVariable Long id);

}