package com.xforceplus.jcvankepurchaser.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2023-08-30
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcvankepurchaser.entity.PilotTaxNo;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-vanke-purchaser")
public interface PilotTaxNoFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/pilotTaxNo/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param pilotTaxNo ${table.comment}
   * @return R
   */
  @PostMapping("/pilotTaxNo/add")
  public R save(@RequestBody PilotTaxNo pilotTaxNo);

  /**
   * 修改${table.comment}
   * @param pilotTaxNo ${table.comment}
   * @return R
   */
  @PostMapping("/pilotTaxNo/update")
  public R updateById(@RequestBody PilotTaxNo pilotTaxNo);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/pilotTaxNo/del/{id}" )
  public R removeById(@PathVariable Long id);

}