package com.xforceplus.jcvankepurchaser.controller;


/**
 * 万科ICP，PDF识别发票类型配置feign客户端
 *
 * @author ultraman
 * @date 2024-02-26
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcvankepurchaser.entity.PdfInvoiceTypeConvert;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-vanke-purchaser")
public interface PdfInvoiceTypeConvertFeignApi {

  /**
   * 通过id查询万科ICP，PDF识别发票类型配置
   * @param  id
   * @return R
   */
  @GetMapping("/pdfInvoiceTypeConvert/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增万科ICP，PDF识别发票类型配置
   * @param pdfInvoiceTypeConvert 万科ICP，PDF识别发票类型配置
   * @return R
   */
  @PostMapping("/pdfInvoiceTypeConvert/add")
  public R save(@RequestBody PdfInvoiceTypeConvert pdfInvoiceTypeConvert);

  /**
   * 修改万科ICP，PDF识别发票类型配置
   * @param pdfInvoiceTypeConvert 万科ICP，PDF识别发票类型配置
   * @return R
   */
  @PostMapping("/pdfInvoiceTypeConvert/update")
  public R updateById(@RequestBody PdfInvoiceTypeConvert pdfInvoiceTypeConvert);

  /**
   * 通过id删除万科ICP，PDF识别发票类型配置
   * @param  id
   * @return R
   */
  @DeleteMapping("/pdfInvoiceTypeConvert/del/{id}" )
  public R removeById(@PathVariable Long id);

}