package com.xforceplus.jcvankepurchaser.controller;


/**
 * 报表主数据feign客户端
 *
 * @author ultraman
 * @date 2023-08-14
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcvankepurchaser.entity.Threshold;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-vanke-purchaser")
public interface ThresholdFeignApi {

  /**
   * 通过id查询报表主数据
   * @param  id
   * @return R
   */
  @GetMapping("/threshold/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增报表主数据
   * @param threshold 报表主数据
   * @return R
   */
  @PostMapping("/threshold/add")
  public R save(@RequestBody Threshold threshold);

  /**
   * 修改报表主数据
   * @param threshold 报表主数据
   * @return R
   */
  @PostMapping("/threshold/update")
  public R updateById(@RequestBody Threshold threshold);

  /**
   * 通过id删除报表主数据
   * @param  id
   * @return R
   */
  @DeleteMapping("/threshold/del/{id}" )
  public R removeById(@PathVariable Long id);

}