package com.xforceplus.jcvankepurchaser.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcvankepurchaser.entity.OrderLifeCircle;
import com.xforceplus.jcvankepurchaser.service.IOrderLifeCircleService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 报表前端控制器
 *
 * @author ultraman
 * @date 2023-08-29
 */
@RestController
public class OrderLifeCircleController {

  @Autowired
  private IOrderLifeCircleService orderLifeCircleServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderLifeCircle 报表
   * @return
   */
  @GetMapping("/orderlifecircles" )
  public XfR getOrderLifeCircles(XfPage page, OrderLifeCircle orderLifeCircle) {
    return XfR.ok(orderLifeCircleServiceImpl.page(page, Wrappers.query(orderLifeCircle)));
  }

  /**
   * 通过id查询报表
   * @param  id
   * @return XfR
   */
  @GetMapping("/orderlifecircles/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderLifeCircleServiceImpl.getById(id));
  }

  /**
   * 新增报表
   * @param orderLifeCircle 报表
   * @return XfR
   */
  @PostMapping("/orderlifecircles")
  public XfR save(@RequestBody OrderLifeCircle orderLifeCircle) {
     return XfR.ok(orderLifeCircleServiceImpl.save(orderLifeCircle));
  }

  /**
   * 修改-传入修改后的全部数据报表
   * @param orderLifeCircle 报表
   * @return XfR
   */
  @PutMapping("/orderlifecircles/{id}")
  public XfR putUpdate(@RequestBody OrderLifeCircle orderLifeCircle,@PathVariable Long id) {
      orderLifeCircle.setId(id);
      return XfR.ok(orderLifeCircleServiceImpl.updateById(orderLifeCircle));
  }

  /**
   * 修改-传入修改的数据报表
   * @param orderLifeCircle 报表
   * @return XfR
   */
  @PatchMapping("/orderlifecircles/{id}")
  public XfR patchUpdate(@RequestBody OrderLifeCircle orderLifeCircle,@PathVariable Long id) {
      OrderLifeCircle uporderLifeCircle = orderLifeCircleServiceImpl.getById(id);
      if(uporderLifeCircle != null){
        uporderLifeCircle = ObjectCopyUtils.copyProperties(orderLifeCircle,uporderLifeCircle,true);
      }
      return XfR.ok(orderLifeCircleServiceImpl.updateById(uporderLifeCircle));
  }

  /**
   * 通过id删除报表
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orderlifecircles/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderLifeCircleServiceImpl.removeById(id));
  }

  @PostMapping("/orderlifecircles/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "order_life_circle");
     params.put("request", condition);

     return XfR.ok(orderLifeCircleServiceImpl.querys(params));
  }

}
