package com.xforceplus.jcvankepurchaser.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcvankepurchaser.entity.Threshold;
import com.xforceplus.jcvankepurchaser.service.IThresholdService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 报表主数据前端控制器
 *
 * @author ultraman
 * @date 2023-08-29
 */
@RestController
public class ThresholdController {

  @Autowired
  private IThresholdService thresholdServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param threshold 报表主数据
   * @return
   */
  @GetMapping("/thresholds" )
  public XfR getThresholds(XfPage page, Threshold threshold) {
    return XfR.ok(thresholdServiceImpl.page(page, Wrappers.query(threshold)));
  }

  /**
   * 通过id查询报表主数据
   * @param  id
   * @return XfR
   */
  @GetMapping("/thresholds/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(thresholdServiceImpl.getById(id));
  }

  /**
   * 新增报表主数据
   * @param threshold 报表主数据
   * @return XfR
   */
  @PostMapping("/thresholds")
  public XfR save(@RequestBody Threshold threshold) {
     return XfR.ok(thresholdServiceImpl.save(threshold));
  }

  /**
   * 修改-传入修改后的全部数据报表主数据
   * @param threshold 报表主数据
   * @return XfR
   */
  @PutMapping("/thresholds/{id}")
  public XfR putUpdate(@RequestBody Threshold threshold,@PathVariable Long id) {
      threshold.setId(id);
      return XfR.ok(thresholdServiceImpl.updateById(threshold));
  }

  /**
   * 修改-传入修改的数据报表主数据
   * @param threshold 报表主数据
   * @return XfR
   */
  @PatchMapping("/thresholds/{id}")
  public XfR patchUpdate(@RequestBody Threshold threshold,@PathVariable Long id) {
      Threshold upthreshold = thresholdServiceImpl.getById(id);
      if(upthreshold != null){
        upthreshold = ObjectCopyUtils.copyProperties(threshold,upthreshold,true);
      }
      return XfR.ok(thresholdServiceImpl.updateById(upthreshold));
  }

  /**
   * 通过id删除报表主数据
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/thresholds/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(thresholdServiceImpl.removeById(id));
  }

  @PostMapping("/thresholds/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "threshold");
     params.put("request", condition);

     return XfR.ok(thresholdServiceImpl.querys(params));
  }

}
