package com.xforceplus.jcvankepurchaser.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcvankepurchaser.entity.DeliveredTodoTask;
import com.xforceplus.jcvankepurchaser.service.IDeliveredTodoTaskService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-11-30
 */
@RestController
public class DeliveredTodoTaskController {

  @Autowired
  private IDeliveredTodoTaskService deliveredTodoTaskServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param deliveredTodoTask ${table.comment}
   * @return
   */
  @GetMapping("/deliveredtodotasks" )
  public XfR getDeliveredTodoTasks(XfPage page, DeliveredTodoTask deliveredTodoTask) {
    return XfR.ok(deliveredTodoTaskServiceImpl.page(page, Wrappers.query(deliveredTodoTask)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/deliveredtodotasks/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(deliveredTodoTaskServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param deliveredTodoTask ${table.comment}
   * @return XfR
   */
  @PostMapping("/deliveredtodotasks")
  public XfR save(@RequestBody DeliveredTodoTask deliveredTodoTask) {
     return XfR.ok(deliveredTodoTaskServiceImpl.save(deliveredTodoTask));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param deliveredTodoTask ${table.comment}
   * @return XfR
   */
  @PutMapping("/deliveredtodotasks/{id}")
  public XfR putUpdate(@RequestBody DeliveredTodoTask deliveredTodoTask,@PathVariable Long id) {
      deliveredTodoTask.setId(id);
      return XfR.ok(deliveredTodoTaskServiceImpl.updateById(deliveredTodoTask));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param deliveredTodoTask ${table.comment}
   * @return XfR
   */
  @PatchMapping("/deliveredtodotasks/{id}")
  public XfR patchUpdate(@RequestBody DeliveredTodoTask deliveredTodoTask,@PathVariable Long id) {
      DeliveredTodoTask updeliveredTodoTask = deliveredTodoTaskServiceImpl.getById(id);
      if(updeliveredTodoTask != null){
        updeliveredTodoTask = ObjectCopyUtils.copyProperties(deliveredTodoTask,updeliveredTodoTask,true);
      }
      return XfR.ok(deliveredTodoTaskServiceImpl.updateById(updeliveredTodoTask));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/deliveredtodotasks/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(deliveredTodoTaskServiceImpl.removeById(id));
  }

  @PostMapping("/deliveredtodotasks/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "delivered_todo_task");
     params.put("request", condition);

     return XfR.ok(deliveredTodoTaskServiceImpl.querys(params));
  }

}
