package com.xforceplus.jcvankepurchaser.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcvankepurchaser.entity.PdfInvoiceTypeConvert;
import com.xforceplus.jcvankepurchaser.service.IPdfInvoiceTypeConvertService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 万科ICP，PDF识别发票类型配置前端控制器
 *
 * @author ultraman
 * @date 2023-11-30
 */
@RestController
public class PdfInvoiceTypeConvertController {

  @Autowired
  private IPdfInvoiceTypeConvertService pdfInvoiceTypeConvertServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param pdfInvoiceTypeConvert 万科ICP，PDF识别发票类型配置
   * @return
   */
  @GetMapping("/pdfinvoicetypeconverts" )
  public XfR getPdfInvoiceTypeConverts(XfPage page, PdfInvoiceTypeConvert pdfInvoiceTypeConvert) {
    return XfR.ok(pdfInvoiceTypeConvertServiceImpl.page(page, Wrappers.query(pdfInvoiceTypeConvert)));
  }

  /**
   * 通过id查询万科ICP，PDF识别发票类型配置
   * @param  id
   * @return XfR
   */
  @GetMapping("/pdfinvoicetypeconverts/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(pdfInvoiceTypeConvertServiceImpl.getById(id));
  }

  /**
   * 新增万科ICP，PDF识别发票类型配置
   * @param pdfInvoiceTypeConvert 万科ICP，PDF识别发票类型配置
   * @return XfR
   */
  @PostMapping("/pdfinvoicetypeconverts")
  public XfR save(@RequestBody PdfInvoiceTypeConvert pdfInvoiceTypeConvert) {
     return XfR.ok(pdfInvoiceTypeConvertServiceImpl.save(pdfInvoiceTypeConvert));
  }

  /**
   * 修改-传入修改后的全部数据万科ICP，PDF识别发票类型配置
   * @param pdfInvoiceTypeConvert 万科ICP，PDF识别发票类型配置
   * @return XfR
   */
  @PutMapping("/pdfinvoicetypeconverts/{id}")
  public XfR putUpdate(@RequestBody PdfInvoiceTypeConvert pdfInvoiceTypeConvert,@PathVariable Long id) {
      pdfInvoiceTypeConvert.setId(id);
      return XfR.ok(pdfInvoiceTypeConvertServiceImpl.updateById(pdfInvoiceTypeConvert));
  }

  /**
   * 修改-传入修改的数据万科ICP，PDF识别发票类型配置
   * @param pdfInvoiceTypeConvert 万科ICP，PDF识别发票类型配置
   * @return XfR
   */
  @PatchMapping("/pdfinvoicetypeconverts/{id}")
  public XfR patchUpdate(@RequestBody PdfInvoiceTypeConvert pdfInvoiceTypeConvert,@PathVariable Long id) {
      PdfInvoiceTypeConvert uppdfInvoiceTypeConvert = pdfInvoiceTypeConvertServiceImpl.getById(id);
      if(uppdfInvoiceTypeConvert != null){
        uppdfInvoiceTypeConvert = ObjectCopyUtils.copyProperties(pdfInvoiceTypeConvert,uppdfInvoiceTypeConvert,true);
      }
      return XfR.ok(pdfInvoiceTypeConvertServiceImpl.updateById(uppdfInvoiceTypeConvert));
  }

  /**
   * 通过id删除万科ICP，PDF识别发票类型配置
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/pdfinvoicetypeconverts/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(pdfInvoiceTypeConvertServiceImpl.removeById(id));
  }

  @PostMapping("/pdfinvoicetypeconverts/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "pdf_invoice_type_convert");
     params.put("request", condition);

     return XfR.ok(pdfInvoiceTypeConvertServiceImpl.querys(params));
  }

}
