package com.xforceplus.jcvankepurchaser.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcvankepurchaser.entity.PerpetualCalendar;
import com.xforceplus.jcvankepurchaser.service.IPerpetualCalendarService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 报表主数据前端控制器
 *
 * @author ultraman
 * @date 2024-02-28
 */
@RestController
public class PerpetualCalendarController {

  @Autowired
  private IPerpetualCalendarService perpetualCalendarServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param perpetualCalendar 报表主数据
   * @return
   */
  @GetMapping("/perpetualcalendars" )
  public XfR getPerpetualCalendars(XfPage page, PerpetualCalendar perpetualCalendar) {
    return XfR.ok(perpetualCalendarServiceImpl.page(page, Wrappers.query(perpetualCalendar)));
  }

  /**
   * 通过id查询报表主数据
   * @param  id
   * @return XfR
   */
  @GetMapping("/perpetualcalendars/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(perpetualCalendarServiceImpl.getById(id));
  }

  /**
   * 新增报表主数据
   * @param perpetualCalendar 报表主数据
   * @return XfR
   */
  @PostMapping("/perpetualcalendars")
  public XfR save(@RequestBody PerpetualCalendar perpetualCalendar) {
     return XfR.ok(perpetualCalendarServiceImpl.save(perpetualCalendar));
  }

  /**
   * 修改-传入修改后的全部数据报表主数据
   * @param perpetualCalendar 报表主数据
   * @return XfR
   */
  @PutMapping("/perpetualcalendars/{id}")
  public XfR putUpdate(@RequestBody PerpetualCalendar perpetualCalendar,@PathVariable Long id) {
      perpetualCalendar.setId(id);
      return XfR.ok(perpetualCalendarServiceImpl.updateById(perpetualCalendar));
  }

  /**
   * 修改-传入修改的数据报表主数据
   * @param perpetualCalendar 报表主数据
   * @return XfR
   */
  @PatchMapping("/perpetualcalendars/{id}")
  public XfR patchUpdate(@RequestBody PerpetualCalendar perpetualCalendar,@PathVariable Long id) {
      PerpetualCalendar upperpetualCalendar = perpetualCalendarServiceImpl.getById(id);
      if(upperpetualCalendar != null){
        upperpetualCalendar = ObjectCopyUtils.copyProperties(perpetualCalendar,upperpetualCalendar,true);
      }
      return XfR.ok(perpetualCalendarServiceImpl.updateById(upperpetualCalendar));
  }

  /**
   * 通过id删除报表主数据
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/perpetualcalendars/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(perpetualCalendarServiceImpl.removeById(id));
  }

  @PostMapping("/perpetualcalendars/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "perpetual_calendar");
     params.put("request", condition);

     return XfR.ok(perpetualCalendarServiceImpl.querys(params));
  }

}
