package com.xforceplus.jcvankeshare2.controller;


/**
 * 记录关键方法执行的日志feign客户端
 *
 * @author ultraman
 * @date 2023-02-13
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcvankeshare2.entity.MethodOperatLog;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-vanke-share2")
public interface MethodOperatLogFeignApi {

  /**
   * 通过id查询记录关键方法执行的日志
   * @param  id
   * @return R
   */
  @GetMapping("/methodOperatLog/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增记录关键方法执行的日志
   * @param methodOperatLog 记录关键方法执行的日志
   * @return R
   */
  @PostMapping("/methodOperatLog/add")
  public R save(@RequestBody MethodOperatLog methodOperatLog);

  /**
   * 修改记录关键方法执行的日志
   * @param methodOperatLog 记录关键方法执行的日志
   * @return R
   */
  @PostMapping("/methodOperatLog/update")
  public R updateById(@RequestBody MethodOperatLog methodOperatLog);

  /**
   * 通过id删除记录关键方法执行的日志
   * @param  id
   * @return R
   */
  @DeleteMapping("/methodOperatLog/del/{id}" )
  public R removeById(@PathVariable Long id);

}