package com.xforceplus.jcvankeshare2.controller;


/**
 * 组织实体feign客户端
 *
 * @author ultraman
 * @date 2023-02-13
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcvankeshare2.entity.OrgEntity;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-vanke-share2")
public interface OrgEntityFeignApi {

  /**
   * 通过id查询组织实体
   * @param  id
   * @return R
   */
  @GetMapping("/orgEntity/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增组织实体
   * @param orgEntity 组织实体
   * @return R
   */
  @PostMapping("/orgEntity/add")
  public R save(@RequestBody OrgEntity orgEntity);

  /**
   * 修改组织实体
   * @param orgEntity 组织实体
   * @return R
   */
  @PostMapping("/orgEntity/update")
  public R updateById(@RequestBody OrgEntity orgEntity);

  /**
   * 通过id删除组织实体
   * @param  id
   * @return R
   */
  @DeleteMapping("/orgEntity/del/{id}" )
  public R removeById(@PathVariable Long id);

}