package com.xforceplus.jcvankeshare2.controller;


/**
 * 组织对象操作日志-操作履历feign客户端
 *
 * @author ultraman
 * @date 2023-02-13
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcvankeshare2.entity.OrgEntityOpeartLog;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-vanke-share2")
public interface OrgEntityOpeartLogFeignApi {

  /**
   * 通过id查询组织对象操作日志-操作履历
   * @param  id
   * @return R
   */
  @GetMapping("/orgEntityOpeartLog/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增组织对象操作日志-操作履历
   * @param orgEntityOpeartLog 组织对象操作日志-操作履历
   * @return R
   */
  @PostMapping("/orgEntityOpeartLog/add")
  public R save(@RequestBody OrgEntityOpeartLog orgEntityOpeartLog);

  /**
   * 修改组织对象操作日志-操作履历
   * @param orgEntityOpeartLog 组织对象操作日志-操作履历
   * @return R
   */
  @PostMapping("/orgEntityOpeartLog/update")
  public R updateById(@RequestBody OrgEntityOpeartLog orgEntityOpeartLog);

  /**
   * 通过id删除组织对象操作日志-操作履历
   * @param  id
   * @return R
   */
  @DeleteMapping("/orgEntityOpeartLog/del/{id}" )
  public R removeById(@PathVariable Long id);

}