package com.xforceplus.jcvankeshare2.controller;


/**
 * 系统日志，用来记录详细系统日志feign客户端
 *
 * @author ultraman
 * @date 2023-02-13
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcvankeshare2.entity.SystemLog;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-vanke-share2")
public interface SystemLogFeignApi {

  /**
   * 通过id查询系统日志，用来记录详细系统日志
   * @param  id
   * @return R
   */
  @GetMapping("/systemLog/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增系统日志，用来记录详细系统日志
   * @param systemLog 系统日志，用来记录详细系统日志
   * @return R
   */
  @PostMapping("/systemLog/add")
  public R save(@RequestBody SystemLog systemLog);

  /**
   * 修改系统日志，用来记录详细系统日志
   * @param systemLog 系统日志，用来记录详细系统日志
   * @return R
   */
  @PostMapping("/systemLog/update")
  public R updateById(@RequestBody SystemLog systemLog);

  /**
   * 通过id删除系统日志，用来记录详细系统日志
   * @param  id
   * @return R
   */
  @DeleteMapping("/systemLog/del/{id}" )
  public R removeById(@PathVariable Long id);

}