package com.xforceplus.jcvankeshare2.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcvankeshare2.entity.OrgEntity;
import com.xforceplus.jcvankeshare2.service.IOrgEntityService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 组织实体前端控制器
 *
 * @author ultraman
 * @date 2023-02-13
 */
@RestController
public class OrgEntityController {

  @Autowired
  private IOrgEntityService orgEntityServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orgEntity 组织实体
   * @return
   */
  @GetMapping("/orgentitys" )
  public XfR getOrgEntitys(XfPage page, OrgEntity orgEntity) {
    return XfR.ok(orgEntityServiceImpl.page(page, Wrappers.query(orgEntity)));
  }

  /**
   * 通过id查询组织实体
   * @param  id
   * @return XfR
   */
  @GetMapping("/orgentitys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orgEntityServiceImpl.getById(id));
  }

  /**
   * 新增组织实体
   * @param orgEntity 组织实体
   * @return XfR
   */
  @PostMapping("/orgentitys")
  public XfR save(@RequestBody OrgEntity orgEntity) {
     return XfR.ok(orgEntityServiceImpl.save(orgEntity));
  }

  /**
   * 修改-传入修改后的全部数据组织实体
   * @param orgEntity 组织实体
   * @return XfR
   */
  @PutMapping("/orgentitys/{id}")
  public XfR putUpdate(@RequestBody OrgEntity orgEntity,@PathVariable Long id) {
      orgEntity.setId(id);
      return XfR.ok(orgEntityServiceImpl.updateById(orgEntity));
  }

  /**
   * 修改-传入修改的数据组织实体
   * @param orgEntity 组织实体
   * @return XfR
   */
  @PatchMapping("/orgentitys/{id}")
  public XfR patchUpdate(@RequestBody OrgEntity orgEntity,@PathVariable Long id) {
      OrgEntity uporgEntity = orgEntityServiceImpl.getById(id);
      if(uporgEntity != null){
        uporgEntity = ObjectCopyUtils.copyProperties(orgEntity,uporgEntity,true);
      }
      return XfR.ok(orgEntityServiceImpl.updateById(uporgEntity));
  }

  /**
   * 通过id删除组织实体
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orgentitys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orgEntityServiceImpl.removeById(id));
  }

  @PostMapping("/orgentitys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "org_entity");
     params.put("request", condition);

     return XfR.ok(orgEntityServiceImpl.querys(params));
  }

}
