package com.xforceplus.jcvankeshare2.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcvankeshare2.entity.MethodOperatLog;
import com.xforceplus.jcvankeshare2.service.IMethodOperatLogService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 记录关键方法执行的日志前端控制器
 *
 * @author ultraman
 * @date 2023-02-13
 */
@RestController
public class MethodOperatLogController {

  @Autowired
  private IMethodOperatLogService methodOperatLogServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param methodOperatLog 记录关键方法执行的日志
   * @return
   */
  @GetMapping("/methodoperatlogs" )
  public XfR getMethodOperatLogs(XfPage page, MethodOperatLog methodOperatLog) {
    return XfR.ok(methodOperatLogServiceImpl.page(page, Wrappers.query(methodOperatLog)));
  }

  /**
   * 通过id查询记录关键方法执行的日志
   * @param  id
   * @return XfR
   */
  @GetMapping("/methodoperatlogs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(methodOperatLogServiceImpl.getById(id));
  }

  /**
   * 新增记录关键方法执行的日志
   * @param methodOperatLog 记录关键方法执行的日志
   * @return XfR
   */
  @PostMapping("/methodoperatlogs")
  public XfR save(@RequestBody MethodOperatLog methodOperatLog) {
     return XfR.ok(methodOperatLogServiceImpl.save(methodOperatLog));
  }

  /**
   * 修改-传入修改后的全部数据记录关键方法执行的日志
   * @param methodOperatLog 记录关键方法执行的日志
   * @return XfR
   */
  @PutMapping("/methodoperatlogs/{id}")
  public XfR putUpdate(@RequestBody MethodOperatLog methodOperatLog,@PathVariable Long id) {
      methodOperatLog.setId(id);
      return XfR.ok(methodOperatLogServiceImpl.updateById(methodOperatLog));
  }

  /**
   * 修改-传入修改的数据记录关键方法执行的日志
   * @param methodOperatLog 记录关键方法执行的日志
   * @return XfR
   */
  @PatchMapping("/methodoperatlogs/{id}")
  public XfR patchUpdate(@RequestBody MethodOperatLog methodOperatLog,@PathVariable Long id) {
      MethodOperatLog upmethodOperatLog = methodOperatLogServiceImpl.getById(id);
      if(upmethodOperatLog != null){
        upmethodOperatLog = ObjectCopyUtils.copyProperties(methodOperatLog,upmethodOperatLog,true);
      }
      return XfR.ok(methodOperatLogServiceImpl.updateById(upmethodOperatLog));
  }

  /**
   * 通过id删除记录关键方法执行的日志
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/methodoperatlogs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(methodOperatLogServiceImpl.removeById(id));
  }

  @PostMapping("/methodoperatlogs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "method_operat_log");
     params.put("request", condition);

     return XfR.ok(methodOperatLogServiceImpl.querys(params));
  }

}
