package com.xforceplus.jcvankeshare2.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcvankeshare2.entity.OrgEntityOpeartLog;
import com.xforceplus.jcvankeshare2.service.IOrgEntityOpeartLogService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 组织对象操作日志-操作履历前端控制器
 *
 * @author ultraman
 * @date 2023-02-13
 */
@RestController
public class OrgEntityOpeartLogController {

  @Autowired
  private IOrgEntityOpeartLogService orgEntityOpeartLogServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orgEntityOpeartLog 组织对象操作日志-操作履历
   * @return
   */
  @GetMapping("/orgentityopeartlogs" )
  public XfR getOrgEntityOpeartLogs(XfPage page, OrgEntityOpeartLog orgEntityOpeartLog) {
    return XfR.ok(orgEntityOpeartLogServiceImpl.page(page, Wrappers.query(orgEntityOpeartLog)));
  }

  /**
   * 通过id查询组织对象操作日志-操作履历
   * @param  id
   * @return XfR
   */
  @GetMapping("/orgentityopeartlogs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orgEntityOpeartLogServiceImpl.getById(id));
  }

  /**
   * 新增组织对象操作日志-操作履历
   * @param orgEntityOpeartLog 组织对象操作日志-操作履历
   * @return XfR
   */
  @PostMapping("/orgentityopeartlogs")
  public XfR save(@RequestBody OrgEntityOpeartLog orgEntityOpeartLog) {
     return XfR.ok(orgEntityOpeartLogServiceImpl.save(orgEntityOpeartLog));
  }

  /**
   * 修改-传入修改后的全部数据组织对象操作日志-操作履历
   * @param orgEntityOpeartLog 组织对象操作日志-操作履历
   * @return XfR
   */
  @PutMapping("/orgentityopeartlogs/{id}")
  public XfR putUpdate(@RequestBody OrgEntityOpeartLog orgEntityOpeartLog,@PathVariable Long id) {
      orgEntityOpeartLog.setId(id);
      return XfR.ok(orgEntityOpeartLogServiceImpl.updateById(orgEntityOpeartLog));
  }

  /**
   * 修改-传入修改的数据组织对象操作日志-操作履历
   * @param orgEntityOpeartLog 组织对象操作日志-操作履历
   * @return XfR
   */
  @PatchMapping("/orgentityopeartlogs/{id}")
  public XfR patchUpdate(@RequestBody OrgEntityOpeartLog orgEntityOpeartLog,@PathVariable Long id) {
      OrgEntityOpeartLog uporgEntityOpeartLog = orgEntityOpeartLogServiceImpl.getById(id);
      if(uporgEntityOpeartLog != null){
        uporgEntityOpeartLog = ObjectCopyUtils.copyProperties(orgEntityOpeartLog,uporgEntityOpeartLog,true);
      }
      return XfR.ok(orgEntityOpeartLogServiceImpl.updateById(uporgEntityOpeartLog));
  }

  /**
   * 通过id删除组织对象操作日志-操作履历
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orgentityopeartlogs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orgEntityOpeartLogServiceImpl.removeById(id));
  }

  @PostMapping("/orgentityopeartlogs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "org_entity_opeart_log");
     params.put("request", condition);

     return XfR.ok(orgEntityOpeartLogServiceImpl.querys(params));
  }

}
