package com.xforceplus.jcvankeshare2.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcvankeshare2.entity.SystemLog;
import com.xforceplus.jcvankeshare2.service.ISystemLogService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 系统日志，用来记录详细系统日志前端控制器
 *
 * @author ultraman
 * @date 2023-02-13
 */
@RestController
public class SystemLogController {

  @Autowired
  private ISystemLogService systemLogServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param systemLog 系统日志，用来记录详细系统日志
   * @return
   */
  @GetMapping("/systemlogs" )
  public XfR getSystemLogs(XfPage page, SystemLog systemLog) {
    return XfR.ok(systemLogServiceImpl.page(page, Wrappers.query(systemLog)));
  }

  /**
   * 通过id查询系统日志，用来记录详细系统日志
   * @param  id
   * @return XfR
   */
  @GetMapping("/systemlogs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(systemLogServiceImpl.getById(id));
  }

  /**
   * 新增系统日志，用来记录详细系统日志
   * @param systemLog 系统日志，用来记录详细系统日志
   * @return XfR
   */
  @PostMapping("/systemlogs")
  public XfR save(@RequestBody SystemLog systemLog) {
     return XfR.ok(systemLogServiceImpl.save(systemLog));
  }

  /**
   * 修改-传入修改后的全部数据系统日志，用来记录详细系统日志
   * @param systemLog 系统日志，用来记录详细系统日志
   * @return XfR
   */
  @PutMapping("/systemlogs/{id}")
  public XfR putUpdate(@RequestBody SystemLog systemLog,@PathVariable Long id) {
      systemLog.setId(id);
      return XfR.ok(systemLogServiceImpl.updateById(systemLog));
  }

  /**
   * 修改-传入修改的数据系统日志，用来记录详细系统日志
   * @param systemLog 系统日志，用来记录详细系统日志
   * @return XfR
   */
  @PatchMapping("/systemlogs/{id}")
  public XfR patchUpdate(@RequestBody SystemLog systemLog,@PathVariable Long id) {
      SystemLog upsystemLog = systemLogServiceImpl.getById(id);
      if(upsystemLog != null){
        upsystemLog = ObjectCopyUtils.copyProperties(systemLog,upsystemLog,true);
      }
      return XfR.ok(systemLogServiceImpl.updateById(upsystemLog));
  }

  /**
   * 通过id删除系统日志，用来记录详细系统日志
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/systemlogs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(systemLogServiceImpl.removeById(id));
  }

  @PostMapping("/systemlogs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "system_log");
     params.put("request", condition);

     return XfR.ok(systemLogServiceImpl.querys(params));
  }

}
