package com.xforceplus.jcwatsons.controller;


/**
 * 存储rental同步过来的销方信息（仅有销方名称），和通过导入Excel维护的Tax销方信息feign客户端
 *
 * @author ultraman
 * @date 2023-04-07
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcwatsons.entity.SellerInfo;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-watsons")
public interface SellerInfoFeignApi {

  /**
   * 通过id查询存储rental同步过来的销方信息（仅有销方名称），和通过导入Excel维护的Tax销方信息
   * @param  id
   * @return R
   */
  @GetMapping("/sellerInfo/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增存储rental同步过来的销方信息（仅有销方名称），和通过导入Excel维护的Tax销方信息
   * @param sellerInfo 存储rental同步过来的销方信息（仅有销方名称），和通过导入Excel维护的Tax销方信息
   * @return R
   */
  @PostMapping("/sellerInfo/add")
  public R save(@RequestBody SellerInfo sellerInfo);

  /**
   * 修改存储rental同步过来的销方信息（仅有销方名称），和通过导入Excel维护的Tax销方信息
   * @param sellerInfo 存储rental同步过来的销方信息（仅有销方名称），和通过导入Excel维护的Tax销方信息
   * @return R
   */
  @PostMapping("/sellerInfo/update")
  public R updateById(@RequestBody SellerInfo sellerInfo);

  /**
   * 通过id删除存储rental同步过来的销方信息（仅有销方名称），和通过导入Excel维护的Tax销方信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/sellerInfo/del/{id}" )
  public R removeById(@PathVariable Long id);

}