package com.xforceplus.jcwatsons.controller;


/**
 * 组别相关信息包含对应的分录数据feign客户端
 *
 * @author ultraman
 * @date 2023-04-17
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcwatsons.entity.GroupInfo;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-watsons")
public interface GroupInfoFeignApi {

  /**
   * 通过id查询组别相关信息包含对应的分录数据
   * @param  id
   * @return R
   */
  @GetMapping("/groupInfo/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增组别相关信息包含对应的分录数据
   * @param groupInfo 组别相关信息包含对应的分录数据
   * @return R
   */
  @PostMapping("/groupInfo/add")
  public R save(@RequestBody GroupInfo groupInfo);

  /**
   * 修改组别相关信息包含对应的分录数据
   * @param groupInfo 组别相关信息包含对应的分录数据
   * @return R
   */
  @PostMapping("/groupInfo/update")
  public R updateById(@RequestBody GroupInfo groupInfo);

  /**
   * 通过id删除组别相关信息包含对应的分录数据
   * @param  id
   * @return R
   */
  @DeleteMapping("/groupInfo/del/{id}" )
  public R removeById(@PathVariable Long id);

}