package com.xforceplus.jcwatsons.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 处理器类型
 * </p>
 *
 * @author ultraman
 * @since 2023-04-13
 */
public enum HandleType {

    RESTAPI_DICTIONARY("restapi_dictionary", "主信息字典远程API校验"),
    SINK_KAFKA("sink_kafka", "下发Kafka"),
    BUSINESS_NO("business_no", "业务代码"),
    DICTIONARY_LOCAL("dictionary_local", "主信息本地字典映射"),
    DICTIONARY_LOCAL_DETAIL("dictionary_local_detail", "明细信息本地字典映射"),
    DETAIL_RESTAPI_DICTIONARY("detail_restapi_dictionary", "明细信息字典远程API校验"),
    SINK_JANUS("sink_janus", "下发集成平台");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    HandleType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static HandleType fromCode(String code){
        switch(code) {
            case "restapi_dictionary":
                return RESTAPI_DICTIONARY;
            case "sink_kafka":
                return SINK_KAFKA;
            case "business_no":
                return BUSINESS_NO;
            case "dictionary_local":
                return DICTIONARY_LOCAL;
            case "dictionary_local_detail":
                return DICTIONARY_LOCAL_DETAIL;
            case "detail_restapi_dictionary":
                return DETAIL_RESTAPI_DICTIONARY;
            case "sink_janus":
                return SINK_JANUS;
            default:
                return null;
        }
    }
}
