package com.xforceplus.jcwatsons.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2023-04-13
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class TaxNumberList implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 市场
   */
  private String market;

  /**
   * 区域
   */
  private String region;

  /**
   * JV/PC
   */
  private String jvPc;

  /**
   * JV CODE
   */
  private String jvCode;

  /**
   * RMS代码
   */
  private String rmsCode;

  /**
   * 公司编码
   */
  private String companyCode;

  /**
   * 公司名称
   */
  private String companyName;

  /**
   * 公司税号
   */
  private String companyTaxno;

  /**
   * 纳税人类型
   */
  @TableField("taxpayerType")
  private String taxpayerType;

  /**
   * 税号主店
   */
  private String mainStore;

  /**
   * 归档账套
   */
  private String archivalCover;

  /**
   * 成本中心
   */
  private String costCenter;

  /**
   * 启停状态
   */
  @TableField("isOpen")
  private String isOpen;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("market", market);
      map.put("region", region);
      map.put("jv_pc", jvPc);
      map.put("jv_code", jvCode);
      map.put("rms_code", rmsCode);
      map.put("company_code", companyCode);
      map.put("company_name", companyName);
      map.put("company_taxno", companyTaxno);
      map.put("taxpayerType", taxpayerType);
      map.put("main_store", mainStore);
      map.put("archival_cover", archivalCover);
      map.put("cost_center", costCenter);
      map.put("isOpen", isOpen);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static TaxNumberList fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    TaxNumberList entity = new TaxNumberList();
    if(map.containsKey("market")) {
      Object obj = map.get("market");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMarket((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("region")) {
      Object obj = map.get("region");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRegion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jv_pc")) {
      Object obj = map.get("jv_pc");
      if(obj != null) {
        if(obj instanceof String){
          entity.setJvPc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jv_code")) {
      Object obj = map.get("jv_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setJvCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rms_code")) {
      Object obj = map.get("rms_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRmsCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_code")) {
      Object obj = map.get("company_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_taxno")) {
      Object obj = map.get("company_taxno");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyTaxno((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxpayerType")) {
      Object obj = map.get("taxpayerType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxpayerType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("main_store")) {
      Object obj = map.get("main_store");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMainStore((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("archival_cover")) {
      Object obj = map.get("archival_cover");
      if(obj != null) {
        if(obj instanceof String){
          entity.setArchivalCover((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cost_center")) {
      Object obj = map.get("cost_center");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCostCenter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isOpen")) {
      Object obj = map.get("isOpen");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsOpen((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("market")) {
      Object obj = map.get("market");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMarket((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("region")) {
      Object obj = map.get("region");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRegion((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("jv_pc")) {
      Object obj = map.get("jv_pc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setJvPc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("jv_code")) {
      Object obj = map.get("jv_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setJvCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("rms_code")) {
      Object obj = map.get("rms_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRmsCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("company_code")) {
      Object obj = map.get("company_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("company_taxno")) {
      Object obj = map.get("company_taxno");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyTaxno((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxpayerType")) {
      Object obj = map.get("taxpayerType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxpayerType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("main_store")) {
      Object obj = map.get("main_store");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMainStore((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("archival_cover")) {
      Object obj = map.get("archival_cover");
      if(obj != null) {
        if(obj instanceof String) {
          this.setArchivalCover((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cost_center")) {
      Object obj = map.get("cost_center");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCostCenter((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("isOpen")) {
      Object obj = map.get("isOpen");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsOpen((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
  }
}
