package com.xforceplus.jcwatsonsmatch.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2024-08-14
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcwatsonsmatch.entity.MatchingInvoiceDetail;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-watsons-match")
public interface MatchingInvoiceDetailFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/matchingInvoiceDetail/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param matchingInvoiceDetail ${table.comment}
   * @return R
   */
  @PostMapping("/matchingInvoiceDetail/add")
  public R save(@RequestBody MatchingInvoiceDetail matchingInvoiceDetail);

  /**
   * 修改${table.comment}
   * @param matchingInvoiceDetail ${table.comment}
   * @return R
   */
  @PostMapping("/matchingInvoiceDetail/update")
  public R updateById(@RequestBody MatchingInvoiceDetail matchingInvoiceDetail);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/matchingInvoiceDetail/del/{id}" )
  public R removeById(@PathVariable Long id);

}