package com.xforceplus.jcwatsonsmatch.controller;


/**
 * 系统验证码feign客户端
 *
 * @author ultraman
 * @date 2024-08-14
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcwatsonsmatch.entity.SystemValidateCode;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-watsons-match")
public interface SystemValidateCodeFeignApi {

  /**
   * 通过id查询系统验证码
   * @param  id
   * @return R
   */
  @GetMapping("/systemValidateCode/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增系统验证码
   * @param systemValidateCode 系统验证码
   * @return R
   */
  @PostMapping("/systemValidateCode/add")
  public R save(@RequestBody SystemValidateCode systemValidateCode);

  /**
   * 修改系统验证码
   * @param systemValidateCode 系统验证码
   * @return R
   */
  @PostMapping("/systemValidateCode/update")
  public R updateById(@RequestBody SystemValidateCode systemValidateCode);

  /**
   * 通过id删除系统验证码
   * @param  id
   * @return R
   */
  @DeleteMapping("/systemValidateCode/del/{id}" )
  public R removeById(@PathVariable Long id);

}