package com.xforceplus.jcwatsonsmatch.controller;


/**
 * 系统用户任务对象feign客户端
 *
 * @author ultraman
 * @date 2024-08-14
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcwatsonsmatch.entity.SystemWorkflowUserTask;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-watsons-match")
public interface SystemWorkflowUserTaskFeignApi {

  /**
   * 通过id查询系统用户任务对象
   * @param  id
   * @return R
   */
  @GetMapping("/systemWorkflowUserTask/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增系统用户任务对象
   * @param systemWorkflowUserTask 系统用户任务对象
   * @return R
   */
  @PostMapping("/systemWorkflowUserTask/add")
  public R save(@RequestBody SystemWorkflowUserTask systemWorkflowUserTask);

  /**
   * 修改系统用户任务对象
   * @param systemWorkflowUserTask 系统用户任务对象
   * @return R
   */
  @PostMapping("/systemWorkflowUserTask/update")
  public R updateById(@RequestBody SystemWorkflowUserTask systemWorkflowUserTask);

  /**
   * 通过id删除系统用户任务对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/systemWorkflowUserTask/del/{id}" )
  public R removeById(@PathVariable Long id);

}