package com.xforceplus.jcwatsonsmatch.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2024-08-15
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcwatsonsmatch.entity.BizStore;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-watsons-match")
public interface BizStoreFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/bizStore/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param bizStore ${table.comment}
   * @return R
   */
  @PostMapping("/bizStore/add")
  public R save(@RequestBody BizStore bizStore);

  /**
   * 修改${table.comment}
   * @param bizStore ${table.comment}
   * @return R
   */
  @PostMapping("/bizStore/update")
  public R updateById(@RequestBody BizStore bizStore);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/bizStore/del/{id}" )
  public R removeById(@PathVariable Long id);

}