package com.xforceplus.jcwatsonsmatch.controller;


/**
 * 系统工作流流程实例对象feign客户端
 *
 * @author ultraman
 * @date 2024-09-18
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcwatsonsmatch.entity.SystemWorkflowInstance;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-watsons-match")
public interface SystemWorkflowInstanceFeignApi {

  /**
   * 通过id查询系统工作流流程实例对象
   * @param  id
   * @return R
   */
  @GetMapping("/systemWorkflowInstance/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增系统工作流流程实例对象
   * @param systemWorkflowInstance 系统工作流流程实例对象
   * @return R
   */
  @PostMapping("/systemWorkflowInstance/add")
  public R save(@RequestBody SystemWorkflowInstance systemWorkflowInstance);

  /**
   * 修改系统工作流流程实例对象
   * @param systemWorkflowInstance 系统工作流流程实例对象
   * @return R
   */
  @PostMapping("/systemWorkflowInstance/update")
  public R updateById(@RequestBody SystemWorkflowInstance systemWorkflowInstance);

  /**
   * 通过id删除系统工作流流程实例对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/systemWorkflowInstance/del/{id}" )
  public R removeById(@PathVariable Long id);

}