package com.xforceplus.jcwatsonsmatch.controller;


/**
 * 系统工作流流程实例历史对象feign客户端
 *
 * @author ultraman
 * @date 2024-08-20
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcwatsonsmatch.entity.SystemWorkflowInstanceHistory;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-watsons-match")
public interface SystemWorkflowInstanceHistoryFeignApi {

  /**
   * 通过id查询系统工作流流程实例历史对象
   * @param  id
   * @return R
   */
  @GetMapping("/systemWorkflowInstanceHistory/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增系统工作流流程实例历史对象
   * @param systemWorkflowInstanceHistory 系统工作流流程实例历史对象
   * @return R
   */
  @PostMapping("/systemWorkflowInstanceHistory/add")
  public R save(@RequestBody SystemWorkflowInstanceHistory systemWorkflowInstanceHistory);

  /**
   * 修改系统工作流流程实例历史对象
   * @param systemWorkflowInstanceHistory 系统工作流流程实例历史对象
   * @return R
   */
  @PostMapping("/systemWorkflowInstanceHistory/update")
  public R updateById(@RequestBody SystemWorkflowInstanceHistory systemWorkflowInstanceHistory);

  /**
   * 通过id删除系统工作流流程实例历史对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/systemWorkflowInstanceHistory/del/{id}" )
  public R removeById(@PathVariable Long id);

}