package com.xforceplus.jcwatsonsmatch.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * flow_status
 * </p>
 *
 * @author ultraman
 * @since 2024-08-14
 */
public enum FlowStatus {

    SUCCESS("success", "成功"),
    FAILED("failed", "失败");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    FlowStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FlowStatus fromCode(String code){
        switch(code) {
            case "success":
                return SUCCESS;
            case "failed":
                return FAILED;
            default:
                return null;
        }
    }
}
