package com.xforceplus.jcwatsonsmatch.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * creation_method
 * </p>
 *
 * @author ultraman
 * @since 2024-08-15
 */
public enum CreationMethod {

    SYNC("sync", "同步"),
    MANUAL("manual", "手动创建");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    CreationMethod(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CreationMethod fromCode(String code){
        switch(code) {
            case "sync":
                return SYNC;
            case "manual":
                return MANUAL;
            default:
                return null;
        }
    }
}
