package com.xforceplus.jcwatsonsmatch.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_type_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-08-15
 */
public enum InvoiceTypeEnum {

    S("s", "增值税专用发票"),
    C("c", "增值税普通发票"),
    CE("ce", "增值税电子普票"),
    JU("ju", "增值税卷式发票"),
    T("t", "通用机打发票"),
    _6("6", "收据"),
    _7("7", "附件");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceTypeEnum fromCode(String code){
        switch(code) {
            case "s":
                return S;
            case "c":
                return C;
            case "ce":
                return CE;
            case "ju":
                return JU;
            case "t":
                return T;
            case "6":
                return _6;
            case "7":
                return _7;
            default:
                return null;
        }
    }
}
