package com.xforceplus.jcwatsonsmatch.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * matching_condition_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-08-15
 */
public enum MatchingConditionEnum {

    _11("11", "一对一"),
    _1N("1n", "一对多"),
    N1("n1", "多对一"),
    NN("nn", "多对多");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    MatchingConditionEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MatchingConditionEnum fromCode(String code){
        switch(code) {
            case "11":
                return _11;
            case "1n":
                return _1N;
            case "n1":
                return N1;
            case "nn":
                return NN;
            default:
                return null;
        }
    }
}
