package com.xforceplus.jcwatsonsmatch.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_type_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-09-18
 */
public enum InvoiceTypeEnum {

    _6("6", "收据"),
    _7("7", "附件"),
    _1("1", "增值税普通发票"),
    _2("2", "增值税专用发票"),
    _3("3", "增值税电子普票"),
    _4("4", "增值税卷式发票"),
    _5("5", "通用机打发票"),
    _8("8", "增值税专用电子专票"),
    _10("10", "全电增值税普通发票"),
    _11("11", "全电增值税专用发票"),
    _12("12", "全电增值税纸质普通发票"),
    _13("13", "全电增值税纸质专用发票");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceTypeEnum fromCode(String code){
        switch(code) {
            case "6":
                return _6;
            case "7":
                return _7;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "8":
                return _8;
            case "10":
                return _10;
            case "11":
                return _11;
            case "12":
                return _12;
            case "13":
                return _13;
            default:
                return null;
        }
    }
}
