package com.xforceplus.jcwatsonsmatch.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * pay_bill_type_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-09-18
 */
public enum PayBillTypeEnum {

    LOCK_STATUS("lockStatus", "锁定状态更新"),
    GIVEUP_AMOUNT("giveupAmount", "放弃收票金额更新");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    PayBillTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PayBillTypeEnum fromCode(String code){
        switch(code) {
            case "lockStatus":
                return LOCK_STATUS;
            case "giveupAmount":
                return GIVEUP_AMOUNT;
            default:
                return null;
        }
    }
}
