package com.xforceplus.jcwatsonsmatch.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * pay_log_match_status_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-09-18
 */
public enum PayLogMatchStatusEnum {

    _0("0", "推荐匹配"),
    _1("1", "已匹配");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    PayLogMatchStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PayLogMatchStatusEnum fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            default:
                return null;
        }
    }
}
