package com.xforceplus.jcwatsonsmatch.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * seller_type_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-09-18
 */
public enum SellerTypeEnum {

    COMPANY("COMPANY", "公司"),
    ALL("ALL", "全部");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SellerTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SellerTypeEnum fromCode(String code){
        switch(code) {
            case "COMPANY":
                return COMPANY;
            case "ALL":
                return ALL;
            default:
                return null;
        }
    }
}
