package com.xforceplus.jcwatsonsmatch.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-09-18
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BizStore implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 开店日期
   */
  @TableField("openDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime openDate;

  /**
   * 关店日期
   */
  @TableField("closeDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime closeDate;

  /**
   * 店铺编码
   */
  @TableField("storeNo")
  private String storeNo;

  /**
   * 店铺名称
   */
  @TableField("storeName")
  private String storeName;

  /**
   * 成本中心
   */
  @TableField("costCenter")
  private String costCenter;

  /**
   * 税区(账套)
   */
  @TableField("taxRegion")
  private String taxRegion;

  /**
   * 税区代码
   */
  @TableField("taxRegionCode")
  private String taxRegionCode;

  /**
   * 区域
   */
  private String region;

  /**
   * 市场
   */
  private String market;

  /**
   * 省份
   */
  private String province;

  /**
   * 城市
   */
  private String city;

  /**
   * jv code
   */
  @TableField("companyCode")
  private String companyCode;

  /**
   * jv/pc
   */
  @TableField("englishShortName")
  private String englishShortName;

  /**
   * 费用中心
   */
  @TableField("feeCenter")
  private String feeCenter;

  /**
   * 城市管理员
   */
  @TableField("cityManager")
  private String cityManager;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * Rental门店基础ID
   */
  @TableField("rentalBizStoreId")
  private String rentalBizStoreId;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("openDate", BocpGenUtils.toTimestamp(openDate));
      map.put("closeDate", BocpGenUtils.toTimestamp(closeDate));
      map.put("storeNo", storeNo);
      map.put("storeName", storeName);
      map.put("costCenter", costCenter);
      map.put("taxRegion", taxRegion);
      map.put("taxRegionCode", taxRegionCode);
      map.put("region", region);
      map.put("market", market);
      map.put("province", province);
      map.put("city", city);
      map.put("companyCode", companyCode);
      map.put("englishShortName", englishShortName);
      map.put("feeCenter", feeCenter);
      map.put("cityManager", cityManager);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("rentalBizStoreId", rentalBizStoreId);

      return map;
  }

  public static BizStore fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    BizStore entity = new BizStore();
    if(map.containsKey("openDate")) {
      Object obj = map.get("openDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOpenDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setOpenDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOpenDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOpenDate(null);
      }
    }
    if(map.containsKey("closeDate")) {
      Object obj = map.get("closeDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCloseDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCloseDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCloseDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCloseDate(null);
      }
    }
    if(map.containsKey("storeNo")) {
      Object obj = map.get("storeNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeName")) {
      Object obj = map.get("storeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("costCenter")) {
      Object obj = map.get("costCenter");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCostCenter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRegion")) {
      Object obj = map.get("taxRegion");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxRegion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRegionCode")) {
      Object obj = map.get("taxRegionCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxRegionCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("region")) {
      Object obj = map.get("region");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRegion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("market")) {
      Object obj = map.get("market");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMarket((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("province")) {
      Object obj = map.get("province");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProvince((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("city")) {
      Object obj = map.get("city");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyCode")) {
      Object obj = map.get("companyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("englishShortName")) {
      Object obj = map.get("englishShortName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEnglishShortName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("feeCenter")) {
      Object obj = map.get("feeCenter");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFeeCenter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cityManager")) {
      Object obj = map.get("cityManager");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCityManager((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rentalBizStoreId")) {
      Object obj = map.get("rentalBizStoreId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRentalBizStoreId((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("openDate")) {
      Object obj = map.get("openDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOpenDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setOpenDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOpenDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setOpenDate(null);
      }
    }
    if(map.containsKey("closeDate")) {
      Object obj = map.get("closeDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCloseDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCloseDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCloseDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCloseDate(null);
      }
    }
    if(map.containsKey("storeNo")) {
      Object obj = map.get("storeNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("storeName")) {
      Object obj = map.get("storeName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("costCenter")) {
      Object obj = map.get("costCenter");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCostCenter((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxRegion")) {
      Object obj = map.get("taxRegion");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxRegion((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxRegionCode")) {
      Object obj = map.get("taxRegionCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxRegionCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("region")) {
      Object obj = map.get("region");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRegion((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("market")) {
      Object obj = map.get("market");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMarket((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("province")) {
      Object obj = map.get("province");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProvince((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("city")) {
      Object obj = map.get("city");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCity((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("companyCode")) {
      Object obj = map.get("companyCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("englishShortName")) {
      Object obj = map.get("englishShortName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEnglishShortName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("feeCenter")) {
      Object obj = map.get("feeCenter");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFeeCenter((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cityManager")) {
      Object obj = map.get("cityManager");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCityManager((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("rentalBizStoreId")) {
      Object obj = map.get("rentalBizStoreId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRentalBizStoreId((String)obj);
        }
      } else {
      }
    }
  }
}
