package com.xforceplus.jcwatsonsmatch.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * no_automatic_match_reason_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-11-29
 */
public enum NoAutomaticMatchReasonEnum {

    _1("1", "未配置匹配规则"),
    _2("2", "未匹配到对应付款"),
    _3("3", "其他未匹配原因"),
    _4("4", "发票明细无开票项目"),
    _5("5", "销方未维护基础信息"),
    _6("6", "无待匹配明细发票"),
    _7("7", "发票无门店"),
    _8("8", "发票明细无开票项目大类"),
    _9("9", "发票明细无费用期间"),
    _10("10", "购方未维护基础信息");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    NoAutomaticMatchReasonEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static NoAutomaticMatchReasonEnum fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            case "9":
                return _9;
            case "10":
                return _10;
            default:
                return null;
        }
    }
}
