package com.xforceplus.jcwatsonsmatch.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * operation_type
 * </p>
 *
 * @author ultraman
 * @since 2024-11-29
 */
public enum OperationType {

    DELETE("delete", "删除"),
    UPDATE("update", "更新"),
    SAVE("save", "新增");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    OperationType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OperationType fromCode(String code){
        switch(code) {
            case "delete":
                return DELETE;
            case "update":
                return UPDATE;
            case "save":
                return SAVE;
            default:
                return null;
        }
    }
}
