package com.xforceplus.jcwatsonsmatch.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-11-29
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceDetailOrPayLog implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 付款表ID
   */
  @TableField("payId")
  private Long payId;

  /**
   * 发票与付款记录匹配金额
   */
  private BigDecimal amount;

  /**
   * 发票明细表ID
   */
  @TableField("detailId")
  private Long detailId;

  /**
   * 发票主表ID
   */
  @TableField("invoiceId")
  private Long invoiceId;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * Rental发票ID
   */
  @TableField("rentalInvoiceId")
  private String rentalInvoiceId;

  /**
   * Rental发票明细ID
   */
  @TableField("rentalInvoiceItemId")
  private String rentalInvoiceItemId;

  /**
   * Rental付款记录ID
   */
  @TableField("rentalPayLogId")
  private String rentalPayLogId;

  /**
   * 付款编号
   */
  @TableField("payNo")
  private String payNo;

  /**
   * 供应商名称
   */
  @TableField("providerName")
  private String providerName;

  /**
   * 摘要
   */
  private String remark;

  /**
   * 付款类型
   */
  @TableField("chargeType")
  private String chargeType;

  /**
   * 付款项目名称
   */
  @TableField("itemName")
  private String itemName;

  /**
   * 费用所属期
   */
  @TableField("chargeStartDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime chargeStartDate;

  /**
   * 费用所属期(止)
   */
  @TableField("chargeEndDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime chargeEndDate;

  /**
   * 付款日期
   */
  @TableField("payDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime payDate;

  /**
   * 付款总金额
   */
  @TableField("totalAmount")
  private BigDecimal totalAmount;

  /**
   * 放弃收票金额
   */
  @TableField("giveupAmount")
  private BigDecimal giveupAmount;

  /**
   * 发票代码
   */
  @TableField("invoiceCode")
  private String invoiceCode;

  /**
   * 发票号码
   */
  @TableField("invoiceNo")
  private String invoiceNo;

  /**
   * 组织树
   */
  private String orgTree;


  /**
   * 对一关联关系 关联对象 matchingInvoiceDetail
   */
    private Long invoiceItemOrMatchId;
  /**
   * 对一关联关系 关联对象 payLog
   */
    private Long payLogOrMatchId;
  /**
   * 对一关联关系 关联对象 matchingInvoiceMain
   */
    private Long invoiceMainOrMatchId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("payId", payId);
      map.put("amount", amount);
      map.put("detailId", detailId);
      map.put("invoiceId", invoiceId);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("rentalInvoiceId", rentalInvoiceId);
      map.put("rentalInvoiceItemId", rentalInvoiceItemId);
      map.put("rentalPayLogId", rentalPayLogId);
      map.put("payNo", payNo);
      map.put("providerName", providerName);
      map.put("remark", remark);
      map.put("chargeType", chargeType);
      map.put("itemName", itemName);
      map.put("chargeStartDate", BocpGenUtils.toTimestamp(chargeStartDate));
      map.put("chargeEndDate", BocpGenUtils.toTimestamp(chargeEndDate));
      map.put("payDate", BocpGenUtils.toTimestamp(payDate));
      map.put("totalAmount", totalAmount);
      map.put("giveupAmount", giveupAmount);
      map.put("invoiceCode", invoiceCode);
      map.put("invoiceNo", invoiceNo);
      map.put("org_tree", orgTree);

       map.put("invoiceItemOrMatch.id", invoiceItemOrMatchId);
       map.put("payLogOrMatch.id", payLogOrMatchId);
       map.put("invoiceMainOrMatch.id", invoiceMainOrMatchId);
      return map;
  }

  public static InvoiceDetailOrPayLog fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    InvoiceDetailOrPayLog entity = new InvoiceDetailOrPayLog();
    if(map.containsKey("payId")) {
      Object obj = map.get("payId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPayId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPayId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPayId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("amount")) {
      Object obj = map.get("amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("detailId")) {
      Object obj = map.get("detailId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDetailId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDetailId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDetailId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceId")) {
      Object obj = map.get("invoiceId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rentalInvoiceId")) {
      Object obj = map.get("rentalInvoiceId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRentalInvoiceId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rentalInvoiceItemId")) {
      Object obj = map.get("rentalInvoiceItemId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRentalInvoiceItemId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rentalPayLogId")) {
      Object obj = map.get("rentalPayLogId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRentalPayLogId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payNo")) {
      Object obj = map.get("payNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("providerName")) {
      Object obj = map.get("providerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProviderName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeType")) {
      Object obj = map.get("chargeType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemName")) {
      Object obj = map.get("itemName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeStartDate")) {
      Object obj = map.get("chargeStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setChargeStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setChargeStartDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setChargeStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setChargeStartDate(null);
      }
    }
    if(map.containsKey("chargeEndDate")) {
      Object obj = map.get("chargeEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setChargeEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setChargeEndDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setChargeEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setChargeEndDate(null);
      }
    }
    if(map.containsKey("payDate")) {
      Object obj = map.get("payDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPayDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setPayDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPayDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPayDate(null);
      }
    }
    if(map.containsKey("totalAmount")) {
      Object obj = map.get("totalAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("giveupAmount")) {
      Object obj = map.get("giveupAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setGiveupAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setGiveupAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setGiveupAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGiveupAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setGiveupAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("invoiceItemOrMatch.id")) {
        Object obj = map.get("invoiceItemOrMatch.id");
      if(obj instanceof Long) {
        entity.setInvoiceItemOrMatchId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setInvoiceItemOrMatchId(Long.parseLong((String)obj));
      }
    }
    if(map.containsKey("payLogOrMatch.id")) {
        Object obj = map.get("payLogOrMatch.id");
      if(obj instanceof Long) {
        entity.setPayLogOrMatchId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setPayLogOrMatchId(Long.parseLong((String)obj));
      }
    }
    if(map.containsKey("invoiceMainOrMatch.id")) {
        Object obj = map.get("invoiceMainOrMatch.id");
      if(obj instanceof Long) {
        entity.setInvoiceMainOrMatchId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setInvoiceMainOrMatchId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("payId")) {
      Object obj = map.get("payId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPayId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPayId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setPayId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("amount")) {
      Object obj = map.get("amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("detailId")) {
      Object obj = map.get("detailId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setDetailId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDetailId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setDetailId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("invoiceId")) {
      Object obj = map.get("invoiceId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setInvoiceId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoiceId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("rentalInvoiceId")) {
      Object obj = map.get("rentalInvoiceId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRentalInvoiceId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("rentalInvoiceItemId")) {
      Object obj = map.get("rentalInvoiceItemId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRentalInvoiceItemId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("rentalPayLogId")) {
      Object obj = map.get("rentalPayLogId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRentalPayLogId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payNo")) {
      Object obj = map.get("payNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("providerName")) {
      Object obj = map.get("providerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProviderName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("chargeType")) {
      Object obj = map.get("chargeType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChargeType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemName")) {
      Object obj = map.get("itemName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("chargeStartDate")) {
      Object obj = map.get("chargeStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setChargeStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setChargeStartDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setChargeStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setChargeStartDate(null);
      }
    }
    if(map.containsKey("chargeEndDate")) {
      Object obj = map.get("chargeEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setChargeEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setChargeEndDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setChargeEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setChargeEndDate(null);
      }
    }
    if(map.containsKey("payDate")) {
      Object obj = map.get("payDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPayDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setPayDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPayDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setPayDate(null);
      }
    }
    if(map.containsKey("totalAmount")) {
      Object obj = map.get("totalAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTotalAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTotalAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTotalAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTotalAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTotalAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("giveupAmount")) {
      Object obj = map.get("giveupAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setGiveupAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setGiveupAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setGiveupAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGiveupAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setGiveupAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("invoiceItemOrMatch.id")) {
        Object obj = map.get("invoiceItemOrMatch.id");
        if(obj instanceof Long) {
          this.setInvoiceItemOrMatchId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceItemOrMatchId(Long.parseLong((String)obj));
        }
      }
      if(map.containsKey("payLogOrMatch.id")) {
        Object obj = map.get("payLogOrMatch.id");
        if(obj instanceof Long) {
          this.setPayLogOrMatchId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPayLogOrMatchId(Long.parseLong((String)obj));
        }
      }
      if(map.containsKey("invoiceMainOrMatch.id")) {
        Object obj = map.get("invoiceMainOrMatch.id");
        if(obj instanceof Long) {
          this.setInvoiceMainOrMatchId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceMainOrMatchId(Long.parseLong((String)obj));
        }
      }
  }
}
