package com.xforceplus.jcwatsonsmatch.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * purchaser_type_enum
 * </p>
 *
 * @author ultraman
 * @since 2025-01-02
 */
public enum PurchaserTypeEnum {

    STORE("STORE", "门店"),
    COMPANY("COMPANY", "公司"),
    ALL("ALL", "全部");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    PurchaserTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PurchaserTypeEnum fromCode(String code){
        switch(code) {
            case "STORE":
                return STORE;
            case "COMPANY":
                return COMPANY;
            case "ALL":
                return ALL;
            default:
                return null;
        }
    }
}
