package com.xforceplus.jcwatsonsmatch.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-08-16
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceDetailOrPayLog implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 付款表ID
   */
  @TableField("payId")
  private Long payId;

  /**
   * 发票与付款记录匹配金额
   */
  private BigDecimal amount;

  /**
   * 发票明细表ID
   */
  @TableField("detailId")
  private Long detailId;

  /**
   * 发票主表ID
   */
  @TableField("invoiceId")
  private Long invoiceId;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * Rental发票ID
   */
  @TableField("rentalInvoiceId")
  private String rentalInvoiceId;

  /**
   * Rental发票明细ID
   */
  @TableField("rentalInvoiceItemId")
  private String rentalInvoiceItemId;

  /**
   * Rental付款记录ID
   */
  @TableField("rentalPayLogId")
  private String rentalPayLogId;


  /**
   * 对一关联关系 关联对象 matchingInvoiceDetail
   */
    private Long invoiceItemOrMatchId;
  /**
   * 对一关联关系 关联对象 payLog
   */
    private Long payLogOrMatchId;
  /**
   * 对一关联关系 关联对象 matchingInvoiceMain
   */
    private Long invoiceMainOrMatchId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("payId", payId);
      map.put("amount", amount);
      map.put("detailId", detailId);
      map.put("invoiceId", invoiceId);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("rentalInvoiceId", rentalInvoiceId);
      map.put("rentalInvoiceItemId", rentalInvoiceItemId);
      map.put("rentalPayLogId", rentalPayLogId);

       map.put("invoiceItemOrMatch.id", invoiceItemOrMatchId);
       map.put("payLogOrMatch.id", payLogOrMatchId);
       map.put("invoiceMainOrMatch.id", invoiceMainOrMatchId);
      return map;
  }

  public static InvoiceDetailOrPayLog fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    InvoiceDetailOrPayLog entity = new InvoiceDetailOrPayLog();
    if(map.containsKey("payId")) {
      Object obj = map.get("payId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPayId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPayId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPayId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("amount")) {
      Object obj = map.get("amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("detailId")) {
      Object obj = map.get("detailId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDetailId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDetailId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDetailId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceId")) {
      Object obj = map.get("invoiceId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rentalInvoiceId")) {
      Object obj = map.get("rentalInvoiceId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRentalInvoiceId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rentalInvoiceItemId")) {
      Object obj = map.get("rentalInvoiceItemId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRentalInvoiceItemId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rentalPayLogId")) {
      Object obj = map.get("rentalPayLogId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRentalPayLogId((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("invoiceItemOrMatch.id")) {
        Object obj = map.get("invoiceItemOrMatch.id");
      if(obj instanceof Long) {
        entity.setInvoiceItemOrMatchId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setInvoiceItemOrMatchId(Long.parseLong((String)obj));
      }
    }
    if(map.containsKey("payLogOrMatch.id")) {
        Object obj = map.get("payLogOrMatch.id");
      if(obj instanceof Long) {
        entity.setPayLogOrMatchId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setPayLogOrMatchId(Long.parseLong((String)obj));
      }
    }
    if(map.containsKey("invoiceMainOrMatch.id")) {
        Object obj = map.get("invoiceMainOrMatch.id");
      if(obj instanceof Long) {
        entity.setInvoiceMainOrMatchId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setInvoiceMainOrMatchId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("payId")) {
      Object obj = map.get("payId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPayId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPayId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setPayId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("amount")) {
      Object obj = map.get("amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("detailId")) {
      Object obj = map.get("detailId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setDetailId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDetailId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setDetailId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("invoiceId")) {
      Object obj = map.get("invoiceId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setInvoiceId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoiceId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("rentalInvoiceId")) {
      Object obj = map.get("rentalInvoiceId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRentalInvoiceId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("rentalInvoiceItemId")) {
      Object obj = map.get("rentalInvoiceItemId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRentalInvoiceItemId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("rentalPayLogId")) {
      Object obj = map.get("rentalPayLogId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRentalPayLogId((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("invoiceItemOrMatch.id")) {
        Object obj = map.get("invoiceItemOrMatch.id");
        if(obj instanceof Long) {
          this.setInvoiceItemOrMatchId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceItemOrMatchId(Long.parseLong((String)obj));
        }
      }
      if(map.containsKey("payLogOrMatch.id")) {
        Object obj = map.get("payLogOrMatch.id");
        if(obj instanceof Long) {
          this.setPayLogOrMatchId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPayLogOrMatchId(Long.parseLong((String)obj));
        }
      }
      if(map.containsKey("invoiceMainOrMatch.id")) {
        Object obj = map.get("invoiceMainOrMatch.id");
        if(obj instanceof Long) {
          this.setInvoiceMainOrMatchId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceMainOrMatchId(Long.parseLong((String)obj));
        }
      }
  }
}
