package com.xforceplus.jcwatsonsmatch.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-08-16
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PayLog implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 付款编号
   */
  @TableField("payNo")
  private String payNo;

  /**
   * 付款申请单行号
   */
  @TableField("lineNo")
  private String lineNo;

  /**
   * 门店号/办公室
   */
  @TableField("storeNo")
  private String storeNo;

  /**
   * 付款类型
   */
  @TableField("chargeType")
  private String chargeType;

  /**
   * 付款项目编号
   */
  @TableField("itemNo")
  private String itemNo;

  /**
   * 付款项目名称
   */
  @TableField("itemName")
  private String itemName;

  /**
   * 付款总金额
   */
  private BigDecimal amount;

  /**
   * 不含税金额
   */
  @TableField("amountWithoutTax")
  private BigDecimal amountWithoutTax;

  /**
   * 税额
   */
  @TableField("amountTax")
  private BigDecimal amountTax;

  /**
   * 供应商名称
   */
  @TableField("providerName")
  private String providerName;

  /**
   * 供应商编号
   */
  @TableField("providerNo")
  private String providerNo;

  /**
   * 付款日期
   */
  @TableField("payDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime payDate;

  /**
   * 摘要
   */
  private String remark;

  /**
   * 费用所属期
   */
  @TableField("chargeStartDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime chargeStartDate;

  /**
   * 费用所属期(止)
   */
  @TableField("chargeEndDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime chargeEndDate;

  /**
   * 放弃收票金额
   */
  @TableField("giveupAmount")
  private BigDecimal giveupAmount;

  /**
   * 是否删除
   */
  @TableField("recordValidity")
  private String recordValidity;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 剩余金额
   */
  @TableField("remainingAmount")
  private BigDecimal remainingAmount;

  /**
   * 已匹配发票号码
   */
  @TableField("matchInvoiceNo")
  private String matchInvoiceNo;

  /**
   * 已匹配金额
   */
  @TableField("alreadyMatchAmount")
  private BigDecimal alreadyMatchAmount;

  /**
   * 匹配状态
   */
  @TableField("matchStatus")
  private String matchStatus;

  /**
   * 本次匹配金额
   */
  @TableField("thisMatchAmount")
  private BigDecimal thisMatchAmount;

  /**
   * Rental付款记录ID
   */
  @TableField("rentalPayLogId")
  private String rentalPayLogId;

  /**
   * 业务参考号
   */
  @TableField("businessNo")
  private String businessNo;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("payNo", payNo);
      map.put("lineNo", lineNo);
      map.put("storeNo", storeNo);
      map.put("chargeType", chargeType);
      map.put("itemNo", itemNo);
      map.put("itemName", itemName);
      map.put("amount", amount);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("amountTax", amountTax);
      map.put("providerName", providerName);
      map.put("providerNo", providerNo);
      map.put("payDate", BocpGenUtils.toTimestamp(payDate));
      map.put("remark", remark);
      map.put("chargeStartDate", BocpGenUtils.toTimestamp(chargeStartDate));
      map.put("chargeEndDate", BocpGenUtils.toTimestamp(chargeEndDate));
      map.put("giveupAmount", giveupAmount);
      map.put("recordValidity", recordValidity);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("remainingAmount", remainingAmount);
      map.put("matchInvoiceNo", matchInvoiceNo);
      map.put("alreadyMatchAmount", alreadyMatchAmount);
      map.put("matchStatus", matchStatus);
      map.put("thisMatchAmount", thisMatchAmount);
      map.put("rentalPayLogId", rentalPayLogId);
      map.put("businessNo", businessNo);

      return map;
  }

  public static PayLog fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    PayLog entity = new PayLog();
    if(map.containsKey("payNo")) {
      Object obj = map.get("payNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lineNo")) {
      Object obj = map.get("lineNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLineNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeNo")) {
      Object obj = map.get("storeNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeType")) {
      Object obj = map.get("chargeType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemNo")) {
      Object obj = map.get("itemNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemName")) {
      Object obj = map.get("itemName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount")) {
      Object obj = map.get("amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountTax")) {
      Object obj = map.get("amountTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("providerName")) {
      Object obj = map.get("providerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProviderName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("providerNo")) {
      Object obj = map.get("providerNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProviderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payDate")) {
      Object obj = map.get("payDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPayDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setPayDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPayDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPayDate(null);
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeStartDate")) {
      Object obj = map.get("chargeStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setChargeStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setChargeStartDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setChargeStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setChargeStartDate(null);
      }
    }
    if(map.containsKey("chargeEndDate")) {
      Object obj = map.get("chargeEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setChargeEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setChargeEndDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setChargeEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setChargeEndDate(null);
      }
    }
    if(map.containsKey("giveupAmount")) {
      Object obj = map.get("giveupAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setGiveupAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setGiveupAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setGiveupAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGiveupAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setGiveupAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("recordValidity")) {
      Object obj = map.get("recordValidity");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRecordValidity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remainingAmount")) {
      Object obj = map.get("remainingAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRemainingAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRemainingAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRemainingAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRemainingAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRemainingAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("matchInvoiceNo")) {
      Object obj = map.get("matchInvoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMatchInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("alreadyMatchAmount")) {
      Object obj = map.get("alreadyMatchAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAlreadyMatchAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAlreadyMatchAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAlreadyMatchAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAlreadyMatchAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAlreadyMatchAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("matchStatus")) {
      Object obj = map.get("matchStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMatchStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("thisMatchAmount")) {
      Object obj = map.get("thisMatchAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setThisMatchAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setThisMatchAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setThisMatchAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setThisMatchAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setThisMatchAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("rentalPayLogId")) {
      Object obj = map.get("rentalPayLogId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRentalPayLogId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessNo")) {
      Object obj = map.get("businessNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessNo((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("payNo")) {
      Object obj = map.get("payNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("lineNo")) {
      Object obj = map.get("lineNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLineNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("storeNo")) {
      Object obj = map.get("storeNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("chargeType")) {
      Object obj = map.get("chargeType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChargeType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemNo")) {
      Object obj = map.get("itemNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemName")) {
      Object obj = map.get("itemName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amount")) {
      Object obj = map.get("amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("amountTax")) {
      Object obj = map.get("amountTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmountTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("providerName")) {
      Object obj = map.get("providerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProviderName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("providerNo")) {
      Object obj = map.get("providerNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProviderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payDate")) {
      Object obj = map.get("payDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPayDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setPayDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPayDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setPayDate(null);
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("chargeStartDate")) {
      Object obj = map.get("chargeStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setChargeStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setChargeStartDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setChargeStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setChargeStartDate(null);
      }
    }
    if(map.containsKey("chargeEndDate")) {
      Object obj = map.get("chargeEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setChargeEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setChargeEndDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setChargeEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setChargeEndDate(null);
      }
    }
    if(map.containsKey("giveupAmount")) {
      Object obj = map.get("giveupAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setGiveupAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setGiveupAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setGiveupAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGiveupAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setGiveupAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("recordValidity")) {
      Object obj = map.get("recordValidity");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRecordValidity((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remainingAmount")) {
      Object obj = map.get("remainingAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setRemainingAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setRemainingAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setRemainingAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRemainingAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setRemainingAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("matchInvoiceNo")) {
      Object obj = map.get("matchInvoiceNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMatchInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("alreadyMatchAmount")) {
      Object obj = map.get("alreadyMatchAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAlreadyMatchAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAlreadyMatchAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAlreadyMatchAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAlreadyMatchAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAlreadyMatchAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("matchStatus")) {
      Object obj = map.get("matchStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMatchStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("thisMatchAmount")) {
      Object obj = map.get("thisMatchAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setThisMatchAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setThisMatchAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setThisMatchAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setThisMatchAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setThisMatchAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("rentalPayLogId")) {
      Object obj = map.get("rentalPayLogId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRentalPayLogId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("businessNo")) {
      Object obj = map.get("businessNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessNo((String)obj);
        }
      } else {
      }
    }
  }
}
