package com.xforceplus.jcwatsonsmatch.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcwatsonsmatch.entity.BizPurchaser;
import com.xforceplus.jcwatsonsmatch.service.IBizPurchaserService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-09-18
 */
@RestController
public class BizPurchaserController {

  @Autowired
  private IBizPurchaserService bizPurchaserServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param bizPurchaser ${table.comment}
   * @return
   */
  @GetMapping("/bizpurchasers" )
  public XfR getBizPurchasers(XfPage page, BizPurchaser bizPurchaser) {
    return XfR.ok(bizPurchaserServiceImpl.page(page, Wrappers.query(bizPurchaser)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/bizpurchasers/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(bizPurchaserServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param bizPurchaser ${table.comment}
   * @return XfR
   */
  @PostMapping("/bizpurchasers")
  public XfR save(@RequestBody BizPurchaser bizPurchaser) {
     return XfR.ok(bizPurchaserServiceImpl.save(bizPurchaser));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param bizPurchaser ${table.comment}
   * @return XfR
   */
  @PutMapping("/bizpurchasers/{id}")
  public XfR putUpdate(@RequestBody BizPurchaser bizPurchaser,@PathVariable Long id) {
      bizPurchaser.setId(id);
      return XfR.ok(bizPurchaserServiceImpl.updateById(bizPurchaser));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param bizPurchaser ${table.comment}
   * @return XfR
   */
  @PatchMapping("/bizpurchasers/{id}")
  public XfR patchUpdate(@RequestBody BizPurchaser bizPurchaser,@PathVariable Long id) {
      BizPurchaser upbizPurchaser = bizPurchaserServiceImpl.getById(id);
      if(upbizPurchaser != null){
        upbizPurchaser = ObjectCopyUtils.copyProperties(bizPurchaser,upbizPurchaser,true);
      }
      return XfR.ok(bizPurchaserServiceImpl.updateById(upbizPurchaser));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bizpurchasers/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(bizPurchaserServiceImpl.removeById(id));
  }

  @PostMapping("/bizpurchasers/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "biz_purchaser");
     params.put("request", condition);

     return XfR.ok(bizPurchaserServiceImpl.querys(params));
  }

}
