package com.xforceplus.jcwatsonsmatch.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcwatsonsmatch.entity.BizSeller;
import com.xforceplus.jcwatsonsmatch.service.IBizSellerService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-09-18
 */
@RestController
public class BizSellerController {

  @Autowired
  private IBizSellerService bizSellerServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param bizSeller ${table.comment}
   * @return
   */
  @GetMapping("/bizsellers" )
  public XfR getBizSellers(XfPage page, BizSeller bizSeller) {
    return XfR.ok(bizSellerServiceImpl.page(page, Wrappers.query(bizSeller)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/bizsellers/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(bizSellerServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param bizSeller ${table.comment}
   * @return XfR
   */
  @PostMapping("/bizsellers")
  public XfR save(@RequestBody BizSeller bizSeller) {
     return XfR.ok(bizSellerServiceImpl.save(bizSeller));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param bizSeller ${table.comment}
   * @return XfR
   */
  @PutMapping("/bizsellers/{id}")
  public XfR putUpdate(@RequestBody BizSeller bizSeller,@PathVariable Long id) {
      bizSeller.setId(id);
      return XfR.ok(bizSellerServiceImpl.updateById(bizSeller));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param bizSeller ${table.comment}
   * @return XfR
   */
  @PatchMapping("/bizsellers/{id}")
  public XfR patchUpdate(@RequestBody BizSeller bizSeller,@PathVariable Long id) {
      BizSeller upbizSeller = bizSellerServiceImpl.getById(id);
      if(upbizSeller != null){
        upbizSeller = ObjectCopyUtils.copyProperties(bizSeller,upbizSeller,true);
      }
      return XfR.ok(bizSellerServiceImpl.updateById(upbizSeller));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bizsellers/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(bizSellerServiceImpl.removeById(id));
  }

  @PostMapping("/bizsellers/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "biz_seller");
     params.put("request", condition);

     return XfR.ok(bizSellerServiceImpl.querys(params));
  }

}
