package com.xforceplus.jcwatsonsmatch.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcwatsonsmatch.entity.MatchingInvoiceDetail;
import com.xforceplus.jcwatsonsmatch.service.IMatchingInvoiceDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-09-18
 */
@RestController
public class MatchingInvoiceDetailController {

  @Autowired
  private IMatchingInvoiceDetailService matchingInvoiceDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param matchingInvoiceDetail ${table.comment}
   * @return
   */
  @GetMapping("/matchinginvoicedetails" )
  public XfR getMatchingInvoiceDetails(XfPage page, MatchingInvoiceDetail matchingInvoiceDetail) {
    return XfR.ok(matchingInvoiceDetailServiceImpl.page(page, Wrappers.query(matchingInvoiceDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/matchinginvoicedetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(matchingInvoiceDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param matchingInvoiceDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/matchinginvoicedetails")
  public XfR save(@RequestBody MatchingInvoiceDetail matchingInvoiceDetail) {
     return XfR.ok(matchingInvoiceDetailServiceImpl.save(matchingInvoiceDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param matchingInvoiceDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/matchinginvoicedetails/{id}")
  public XfR putUpdate(@RequestBody MatchingInvoiceDetail matchingInvoiceDetail,@PathVariable Long id) {
      matchingInvoiceDetail.setId(id);
      return XfR.ok(matchingInvoiceDetailServiceImpl.updateById(matchingInvoiceDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param matchingInvoiceDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/matchinginvoicedetails/{id}")
  public XfR patchUpdate(@RequestBody MatchingInvoiceDetail matchingInvoiceDetail,@PathVariable Long id) {
      MatchingInvoiceDetail upmatchingInvoiceDetail = matchingInvoiceDetailServiceImpl.getById(id);
      if(upmatchingInvoiceDetail != null){
        upmatchingInvoiceDetail = ObjectCopyUtils.copyProperties(matchingInvoiceDetail,upmatchingInvoiceDetail,true);
      }
      return XfR.ok(matchingInvoiceDetailServiceImpl.updateById(upmatchingInvoiceDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/matchinginvoicedetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(matchingInvoiceDetailServiceImpl.removeById(id));
  }

  @PostMapping("/matchinginvoicedetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "matching_invoice_detail");
     params.put("request", condition);

     return XfR.ok(matchingInvoiceDetailServiceImpl.querys(params));
  }

}
