package com.xforceplus.jcwatsonsmatch.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcwatsonsmatch.entity.MatchingInvoiceMain;
import com.xforceplus.jcwatsonsmatch.service.IMatchingInvoiceMainService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-09-18
 */
@RestController
public class MatchingInvoiceMainController {

  @Autowired
  private IMatchingInvoiceMainService matchingInvoiceMainServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param matchingInvoiceMain ${table.comment}
   * @return
   */
  @GetMapping("/matchinginvoicemains" )
  public XfR getMatchingInvoiceMains(XfPage page, MatchingInvoiceMain matchingInvoiceMain) {
    return XfR.ok(matchingInvoiceMainServiceImpl.page(page, Wrappers.query(matchingInvoiceMain)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/matchinginvoicemains/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(matchingInvoiceMainServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param matchingInvoiceMain ${table.comment}
   * @return XfR
   */
  @PostMapping("/matchinginvoicemains")
  public XfR save(@RequestBody MatchingInvoiceMain matchingInvoiceMain) {
     return XfR.ok(matchingInvoiceMainServiceImpl.save(matchingInvoiceMain));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param matchingInvoiceMain ${table.comment}
   * @return XfR
   */
  @PutMapping("/matchinginvoicemains/{id}")
  public XfR putUpdate(@RequestBody MatchingInvoiceMain matchingInvoiceMain,@PathVariable Long id) {
      matchingInvoiceMain.setId(id);
      return XfR.ok(matchingInvoiceMainServiceImpl.updateById(matchingInvoiceMain));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param matchingInvoiceMain ${table.comment}
   * @return XfR
   */
  @PatchMapping("/matchinginvoicemains/{id}")
  public XfR patchUpdate(@RequestBody MatchingInvoiceMain matchingInvoiceMain,@PathVariable Long id) {
      MatchingInvoiceMain upmatchingInvoiceMain = matchingInvoiceMainServiceImpl.getById(id);
      if(upmatchingInvoiceMain != null){
        upmatchingInvoiceMain = ObjectCopyUtils.copyProperties(matchingInvoiceMain,upmatchingInvoiceMain,true);
      }
      return XfR.ok(matchingInvoiceMainServiceImpl.updateById(upmatchingInvoiceMain));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/matchinginvoicemains/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(matchingInvoiceMainServiceImpl.removeById(id));
  }

  @PostMapping("/matchinginvoicemains/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "matching_invoice_main");
     params.put("request", condition);

     return XfR.ok(matchingInvoiceMainServiceImpl.querys(params));
  }

}
