package com.xforceplus.jcwatsonsmatch.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcwatsonsmatch.entity.MatchingRulesConfigDetail;
import com.xforceplus.jcwatsonsmatch.service.IMatchingRulesConfigDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-09-18
 */
@RestController
public class MatchingRulesConfigDetailController {

  @Autowired
  private IMatchingRulesConfigDetailService matchingRulesConfigDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param matchingRulesConfigDetail ${table.comment}
   * @return
   */
  @GetMapping("/matchingrulesconfigdetails" )
  public XfR getMatchingRulesConfigDetails(XfPage page, MatchingRulesConfigDetail matchingRulesConfigDetail) {
    return XfR.ok(matchingRulesConfigDetailServiceImpl.page(page, Wrappers.query(matchingRulesConfigDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/matchingrulesconfigdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(matchingRulesConfigDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param matchingRulesConfigDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/matchingrulesconfigdetails")
  public XfR save(@RequestBody MatchingRulesConfigDetail matchingRulesConfigDetail) {
     return XfR.ok(matchingRulesConfigDetailServiceImpl.save(matchingRulesConfigDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param matchingRulesConfigDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/matchingrulesconfigdetails/{id}")
  public XfR putUpdate(@RequestBody MatchingRulesConfigDetail matchingRulesConfigDetail,@PathVariable Long id) {
      matchingRulesConfigDetail.setId(id);
      return XfR.ok(matchingRulesConfigDetailServiceImpl.updateById(matchingRulesConfigDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param matchingRulesConfigDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/matchingrulesconfigdetails/{id}")
  public XfR patchUpdate(@RequestBody MatchingRulesConfigDetail matchingRulesConfigDetail,@PathVariable Long id) {
      MatchingRulesConfigDetail upmatchingRulesConfigDetail = matchingRulesConfigDetailServiceImpl.getById(id);
      if(upmatchingRulesConfigDetail != null){
        upmatchingRulesConfigDetail = ObjectCopyUtils.copyProperties(matchingRulesConfigDetail,upmatchingRulesConfigDetail,true);
      }
      return XfR.ok(matchingRulesConfigDetailServiceImpl.updateById(upmatchingRulesConfigDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/matchingrulesconfigdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(matchingRulesConfigDetailServiceImpl.removeById(id));
  }

  @PostMapping("/matchingrulesconfigdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "matching_rules_config_detail");
     params.put("request", condition);

     return XfR.ok(matchingRulesConfigDetailServiceImpl.querys(params));
  }

}
